
{$APPTYPE GUI}{$MODE DELPHI}

program demo59;

uses
  SysUtils,windows,math,gl,glu,GraphOGL;

//const
 
//type
  
var 
  base,pozzo:TGLElementBuilding;
  parete:array[1..7]of TGLElementBuilding;
  stairs:TGLElementBuilding;
  TexBase:array[1..2]of gluint;
  TexPozzo:gluint;
  TexParete:array[1..3]of gluint;
   
//{$R *.rc}
//{$R *.res}  


procedure AddDoor(var Element:TGLElementBuilding;x,y:integer);
begin 
  SubQuadFromElement(Element,x,y); SubQuadFromElement(Element,x,y-1); SubQuadFromElement(Element,x,y-2); 
  SubQuadFromElement(Element,x,y-3); SubQuadFromElement(Element,x,y-4); SubQuadFromElement(Element,x,y-5); 
  SubQuadFromElement(Element,x+1,y); SubQuadFromElement(Element,x+1,y-1); SubQuadFromElement(Element,x+1,y-2); 
  SubQuadFromElement(Element,x+1,y-3); SubQuadFromElement(Element,x+1,y-4); SubQuadFromElement(Element,x+1,y-5);
end;


procedure AddWindow(var Element:TGLElementBuilding;x,y:integer);
begin  
  SubQuadFromElement(Element,x,y-3); SubQuadFromElement(Element,x,y-4); SubQuadFromElement(Element,x,y-5); 
  SubQuadFromElement(Element,x+1,y-3); SubQuadFromElement(Element,x+1,y-4); SubQuadFromElement(Element,x+1,y-5);
end;


procedure AddStair(var Element:TGLElementBuilding;x,y:integer;h,d:glfloat);
begin
  MovePointFromElement(stairs,x-2,y,glvector(0,h,1+d),glvector(0,h,0.001+d)); MovePointFromElement(stairs,x-1,y,glvector(0,h,1+d),glvector(0,h,0.001+d));   
  MovePointFromElement(stairs,x,y,glvector(0,h,1+d),glvector(0,h,d)); MovePointFromElement(stairs,x+1,y,glvector(0,h,1+d),glvector(0,h,0.001+d)); 
  MovePointFromElement(stairs,x+2,y,glvector(0,h,1+d),glvector(0,h,0.001+d));
  MovePointFromElement(stairs,x-2,y-1,glvector(0,h,1+d),glvector(0,h,1+d)); MovePointFromElement(stairs,x-1,y-1,glvector(0,h,1+d),glvector(0,h,1+d));   
  MovePointFromElement(stairs,x,y-1,glvector(0,h,1+d),glvector(0,h,1+d)); MovePointFromElement(stairs,x+1,y-1,glvector(0,h,1+d),glvector(0,h,1+d)); 
  MovePointFromElement(stairs,x+2,y-1,glvector(0,h,1+d),glvector(0,h,1+d));  
end;


procedure OpenGL_CreateList();

procedure OpenGL_Texture();
begin    
  
  TextureLoadID('gras.bmp',TexBase[1]);
  TextureLoadID('Floor04.bmp',TexBase[2]);
  TextureLoadID('muro01.bmp',TexPozzo);
  TextureLoadTGAID('rock.tga',TexParete[1]);
  TextureLoadID('Floor04_bmap.bmp',TexParete[2]);    
  TextureLoadID('pavement.bmp',TexParete[3]);  
  
end;
begin 

  OpenGL_Texture();
  
  
  
end;


procedure OpenGL_Draw();

procedure OpenGL_Draw2D();
begin
 
  OpenGL_I2D(0,0,0,0);       // inizializza la grafica 2D 
  
  OpenGL_Init(100,0,0,0,0);  // reimposta la grafica 3D
  
end;
procedure OpenGL_Mouse2D();
begin
  
end;
procedure OpenGL_Keyboard();
begin
  
end;
begin

  glClear(GL_COLOR_BUFFER_BIT OR GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();
 
  OpenGL_Draw2D();               // carica gli elementi per la grafica 2d 
  OpenGL_Mouse2D();              // carica i comandi del mause per la grafica 2d
  OpenGL_Keyboard();             // carica i comandi della tastiera
  
  glTranslatef(0,-2.5,-32.5);        // regola l'inquadratura degli elementi nello schermo
  glRotatef(45,1,0,0); 
  glScalef(0.5,0.5,0.5);
  
  SetglMouseMove(GL_M0,2);    
  
  PutglPointLight(GL_LIGHT0,0, -5,10,2.5, 0.1); 
  
  // base  
  SetElementForBuilding(base,-30,-20, 30,20, TexBase[1],TexBase[2],TexBase[2]);   
  GenElementForBuilding(base,1, 8,6, 10,1/30, 7,5);  
  
  SubOctagonFromElement(base,-22,0);   

  // pozzo  
  glPushMatrix;  
  glTranslatef(-22,1,0);   
  SetElementForBuilding(pozzo,-3,-3, 3,3, TexParete[2],TexPozzo,TexPozzo);   
  GenElementForBuilding(pozzo,2.5, 2.5,2.5, 0.3,0.6, 1,1);    
  glPopMatrix;

  SubOctagonFromElement(pozzo,0,0);
  MovePointFromElement(pozzo,-3,-3,glvector(1.5,0,1.5),glvector(1.5,0,1.5));  
  MovePointFromElement(pozzo,-3,-2,glvector(0.5,0,0.5),glvector(0.5,0,0.5));
  MovePointFromElement(pozzo,-2,-3,glvector(0.5,0,0.5),glvector(0.5,0,0.5));
  
  MovePointFromElement(pozzo,3,-3,glvector(-1.499,-0.1,1.5),glvector(-1.499,-0.1,1.5));  
  MovePointFromElement(pozzo,3,-2,glvector(-0.499,0,0.5),glvector(-0.499,0,0.5));
  MovePointFromElement(pozzo,2,-3,glvector(-0.499,0,0.5),glvector(-0.499,0,0.5));  
  
  MovePointFromElement(pozzo,3,3,glvector(-1.5,0,-1.5),glvector(-1.5,0,-1.5));  
  MovePointFromElement(pozzo,3,2,glvector(-0.5,0,-0.5),glvector(-0.5,0,-0.5));
  MovePointFromElement(pozzo,2,3,glvector(-0.5,0,-0.5),glvector(-0.5,0,-0.5));

  MovePointFromElement(pozzo,-3,3,glvector(1.499,-0.1,-1.499),glvector(1.499,-0.1,-1.499));  
  MovePointFromElement(pozzo,-3,2,glvector(0.5,0,-0.5),glvector(0.5,0,-0.5));
  MovePointFromElement(pozzo,-2,3,glvector(0.5,0,-0.5),glvector(0.5,0,-0.5));  
  
  // edificio  
  glPushMatrix;  
  glTranslatef(10,1,1.55);   
  glRotatef(90,1,0,0);   
  SetElementForBuilding(parete[1],-18,-20, 18,0, TexPozzo,TexParete[2],TexParete[1]);   
  GenElementForBuilding(parete[1],0.5, 6,4, 5,0.4, 7,5);    
  glPopMatrix;  
  
  AddDoor(parete[1],12,0); AddWindow(parete[1],5,0); AddWindow(parete[1],-7,0); AddWindow(parete[1],-14,0);
 
  AddWindow(parete[1],12,-10); AddWindow(parete[1],5,-10); AddWindow(parete[1],-7,-10); AddWindow(parete[1],-14,-10);
   
  SubOctagonFromElement(parete[1],-18,0); SubOctagonFromElement(parete[1],1,-20);   
   
  glPushMatrix;  
  glTranslatef(10,1,-18.05);   
  glRotatef(90,1,0,0);   
  SetElementForBuilding(parete[2],-18,-20, 18,0, TexParete[1],TexParete[2],TexPozzo);   
  GenElementForBuilding(parete[2],0.5, 7,5, 5,0.4, 6,4);    
  glPopMatrix;  
  
  AddWindow(parete[2],12,0); AddWindow(parete[2],5,0); AddWindow(parete[2],-7,0); AddWindow(parete[2],-14,0);
 
  AddWindow(parete[2],12,-10); AddWindow(parete[2],5,-10); AddWindow(parete[2],-7,-10); AddWindow(parete[2],-14,-10);   
  
  glPushMatrix;  
  glTranslatef(10,1,0);
  glRotatef(90,0,1,0);  
  glRotatef(90,1,0,0);   
  SetElementForBuilding(parete[3],-2,-19, 18,0, TexParete[1],TexParete[2],TexParete[1]);   
  GenElementForBuilding(parete[3],0.5, 3,4, 5,0.4, 4.5,5);    
  glPopMatrix;  
  
  AddDoor(parete[3],7,0); AddDoor(parete[3],7,-10); SubOctagonFromElement(parete[3],-2,-20); 
   
  glPushMatrix;  
  glTranslatef(-8.025,1,0);
  glRotatef(90,0,1,0);  
  glRotatef(90,1,0,0);   
  SetElementForBuilding(parete[4],-2,-20, 18,0, TexParete[1],TexParete[2],TexPozzo);   
  GenElementForBuilding(parete[4],0.5, 4.65,5, 5,0.4, 4,4);    
  glPopMatrix;  
  
  AddWindow(parete[4],12,0); AddWindow(parete[4],3,0); AddWindow(parete[4],12,-10); AddWindow(parete[4],3,-10); 
   
  SubOctagonFromElement(parete[4],-2,-1); SubOctagonFromElement(parete[4],0,1);
   
  glPushMatrix;  
  glTranslatef(8.025+19.5,1,0);
  glRotatef(90,0,1,0);  
  glRotatef(90,1,0,0);   
  SetElementForBuilding(parete[5],-2,-20, 18,0, TexPozzo,TexParete[2],TexParete[1]);   
  GenElementForBuilding(parete[5],0.5, 4,4, 5,0.4, 4.65,5);    
  glPopMatrix;  
  
  AddWindow(parete[5],12,0); AddWindow(parete[5],3,0); AddWindow(parete[5],12,-10); AddWindow(parete[5],3,-10); 
   
  glPushMatrix;  
  glTranslatef(10,10,2);
  SetElementForBuilding(parete[6],-18,-20, 18,0, TexParete[3],TexPozzo,TexParete[1]);   
  GenElementForBuilding(parete[6],0.5, 6,4, 5,0.4, 7,5);    
  glPopMatrix;     
  
  AddDoor(parete[6],12,-11); AddDoor(parete[6],13,-11); AddDoor(parete[6],15,-11); 
  
  AddDoor(parete[6],12,-9); AddDoor(parete[6],13,-9); AddDoor(parete[6],15,-9); 
  
  glPushMatrix;  
  glTranslatef(10,20,2);
  SetElementForBuilding(parete[7],-18,-20, 18,0, TexParete[2],TexPozzo,TexParete[1]);   
  GenElementForBuilding(parete[7],0.5, 6,4, 5,0.4, 7,5);    
  glPopMatrix;     
  
  AddDoor(parete[7],12,-11); AddDoor(parete[7],13,-11); AddDoor(parete[7],15,-11); 
  
  AddDoor(parete[7],12,-9); AddDoor(parete[7],13,-9); AddDoor(parete[7],15,-9); 
  
  SubOctagonFromElement(parete[7],1,0); SubOctagonFromElement(parete[7],11,-15); SubOctagonFromElement(parete[7],12,-17);

  SubOctagonFromElement(parete[7],14,-16);    
  
  // scale 
  glPushMatrix;  
  glTranslatef(10+15,1,-6);
  SetElementForBuilding(stairs,-1,-17, 2,0, TexParete[2],TexParete[2],TexParete[2]);   
  GenElementForBuilding(stairs,1.5, 6,4, 5,0.4, 7,5);    
  glPopMatrix;    
  
  AddStair(stairs,0,-2, 1,0); AddStair(stairs,0,-4, 2,1); AddStair(stairs,0,-6, 3,2); AddStair(stairs,0,-8, 4,3);
  
  AddStair(stairs,0,-10, 5,4); AddStair(stairs,0,-12, 6,5); AddStair(stairs,0,-14, 7,6); AddStair(stairs,0,-16, 8,7);
  
  AddStair(stairs,0,-18, 9,8);
  
  glPushMatrix;  
  glTranslatef(10+13,10.5,-15);
  glRotatef(180,0,1,0);   
  SetElementForBuilding(stairs,-1,-17, 2,0, TexParete[2],TexParete[2],TexParete[2]);   
  GenElementForBuilding(stairs,1.5, 6,4, 5,0.4, 7,5);    
  glPopMatrix;    
  
  AddStair(stairs,0,-2, 1,0); AddStair(stairs,0,-4, 2,1); AddStair(stairs,0,-6, 3,2); AddStair(stairs,0,-8, 4,3);
  
  AddStair(stairs,0,-10, 5,4); AddStair(stairs,0,-12, 6,5); AddStair(stairs,0,-14, 7,6); AddStair(stairs,0,-16, 8,7);
  
  AddStair(stairs,0,-18, 9,8);  
  
end;

// inizio del programma
begin

 if MessageBox(0,'Settare lo schermo intero?  ', 'Video!',MB_YESNO OR MB_ICONQUESTION) = IDNO 
  then fullscreen := false else fullscreen := true;
  
 OGLWindowSetting(ARROW,'',GENERIC,'');
 CreateOGLWindow('Sistema per la creazione di modelli', 800, 600, 32, fullscreen);// si possono usare anche dei rapporti diversi da 4/3 o 16/9
 OpenGL_Init(100,0,0,0,0);			  // inizializza la grafica OpenGL(consente d'impostare il colore di sfondo e la profondit della visuale) 
 SetglRefractive();                         // imposta la rifrazione ambientale ed elimina le facce interne
 SetglLight(GL_LIGHT0,0.0,0.0,0.0,0.1);     // imposta la luce ambientale
 OpenGL_CreateList();                       // carica le liste degli oggetti (modelli composti)

 // impostare qui i valori delle variabili   

 REPEAT				     // inizio del ciclo principale

 glCLEAR(GL_COLOR_BUFFER_BIT);
 Setglmsg();

 OpenGL_Draw();             // carica gli elementi che devono essere un aggiornati sullo schermo 
 SwapBuffers(dcWindow);	    // abilita la visualizzazione grafica OpenGL

 // inserire qui eventuali dati aggiuntivi

UNTIL active = false;		// fine del ciclo principale (premere ESC per uscire)

 DeleteOGLWindow();		    // chiude la finestra
end.
