
{$APPTYPE GUI}{$MODE DELPHI}

program demo50;

uses
  SysUtils,windows,math,gl,glu,GOGL_Ext,GraphOGL,GOGL_Collision;

//const
 
//type
  
var 
  BumpMap,NormalMap,ColorMap:gluint; 

   
//{$R *.rc}
//{$R *.res}  
 
 
procedure Quad(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4:glFloat);
begin
  TwoSideON;
  glDisable(GL_CULL_FACE);
  glBegin(GL_QUADS);
   FindNormal(x2,y2,z2,x1,y1,z1,x3,y3,z3);
   glNormal3f(FNormal[1], FNormal[2], FNormal[3]);  
    glBumpTexVertex3f(2,0, x2,y2,z2, 2);
    glBumpTexVertex3f(0,0, x1,y1,z1, 2);
    glBumpTexVertex3f(0,2, x3,y3,z3, 2);  
    glBumpTexVertex3f(2,2, x4,y4,z4, 2);	
  glEnd;
  glEnable(GL_CULL_FACE);
  TwoSideOFF;  
end;


procedure OpenGL_CreateList();

procedure OpenGL_Texture();
begin    
  
  TextureLoadID('AlienCarving_DOT3.bmp',BumpMap);
  TextureLoadID('AlienCarving.bmp',ColorMap);  
  
end;
begin 

  OpenGL_Texture();
  
  Load_GL_version_1_3;  
  
  GenCubeMapNormal(256,NormalMap);   

end;


procedure OpenGL_Draw();

procedure OpenGL_Draw2D();
begin
 
  OpenGL_I2D(0,0,0,0);       // inizializza la grafica 2D 
  
  OpenGL_Init(100,0,0,0,0);  // reimposta la grafica 3D
  
end;
procedure OpenGL_Mouse2D();
begin
  
end;
procedure OpenGL_Keyboard();
begin

end;
begin

  glClear(GL_COLOR_BUFFER_BIT OR GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();
 
  OpenGL_Draw2D();               // carica gli elementi per la grafica 2d 
  OpenGL_Mouse2D();              // carica i comandi del mause per la grafica 2d
  OpenGL_Keyboard();             // carica i comandi della tastiera
  
  glTranslatef(0,-0.3,-20);        // regola l'inquadratura degli elementi nello schermo
  glRotatef(0,1,0,0);  
  
  SetglMouseMove(GL_M0,2);   
  
  PutglPointLight(GL_LIGHT0,0, 0,0,2, 0.1);    
  
  glActiveTexture(GL_TEXTURE0); 
  glEnable(GL_TEXTURE_CUBE_MAP); 
  BindBumpMap(BIND_NORMAL,NormalMap); 
 
  glActiveTexture(GL_TEXTURE1); 
  glEnable(GL_TEXTURE_2D); 
  BindBumpMap(BIND_BUMP,BumpMap); 

  glActiveTexture(GL_TEXTURE2); 
  glEnable(GL_TEXTURE_2D); 
  BindBumpMap(BIND_COLOR,ColorMap);  
    
  Quad(-7,-7,0, 7,-7,0, -7,7,0, 7,7,0);
  
  glActiveTexture(GL_TEXTURE0); 
  glDisable(GL_TEXTURE_CUBE_MAP); 
  glActiveTexture(GL_TEXTURE1); 
  glDisable(GL_TEXTURE_2D); 
  glActiveTexture(GL_TEXTURE2); 
  glDisable(GL_TEXTURE_2D); 
  
end;

// inizio del programma
begin

 if MessageBox(0,'Settare lo schermo intero?  ', 'Video!',MB_YESNO OR MB_ICONQUESTION) = IDNO 
  then fullscreen := false else fullscreen := true;
  
 OGLWindowSetting(ARROW,'',GENERIC,'');
 CreateOGLWindow('Bump map dinamico', 800, 600, 32, fullscreen);// si possono usare anche dei rapporti diversi da 4/3 o 16/9
 OpenGL_Init(100,0,0,0,0);			  // inizializza la grafica OpenGL(consente d'impostare il colore di sfondo e la profondit della visuale) 
 SetglRefractive();                         // imposta la rifrazione ambientale ed elimina le facce interne
 SetglLight(GL_LIGHT0,0.0,0.0,0.0,0.1);     // imposta la luce ambientale
 OpenGL_CreateList();                       // carica le liste degli oggetti (modelli composti)

 // impostare qui i valori delle variabili   

 REPEAT				     // inizio del ciclo principale

 glCLEAR(GL_COLOR_BUFFER_BIT);
 Setglmsg();

 OpenGL_Draw();             // carica gli elementi che devono essere un aggiornati sullo schermo 
 SwapBuffers(dcWindow);	    // abilita la visualizzazione grafica OpenGL

 // inserire qui eventuali dati aggiuntivi

UNTIL active = false;		// fine del ciclo principale (premere ESC per uscire)

 DeleteOGLWindow();		    // chiude la finestra
end.
