
{$APPTYPE GUI}{$MODE DELPHI}

program demo43;

uses
  SysUtils,windows,math,gl,glu,GraphOGL,GOGL_Games;

//const
 
//type
  
var
  rain:FX_Nature; 
   
//{$R *.rc}
//{$R *.res}  
 
 
procedure Quad(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,tu,tv:glFloat);
begin
  TwoSideON;
  glDisable(GL_CULL_FACE);
  glBegin(GL_QUADS);
   FindNormal(x2,y2,z2,x1,y1,z1,x3,y3,z3);
   glNormal3f(FNormal[1], FNormal[2], FNormal[3]);
	LineFree(1*tu,-1*tv, 0,-1*tv, x2,y2,z2, x1,y1,z1,true);
	LineFree(0,0, 1*tu,0, x3,y3,z3, x4,y4,z4,true);	
  glEnd;
  glEnable(GL_CULL_FACE);
  TwoSideOFF;  
end;  


procedure RainParticle;
begin
  glDisable(GL_LIGHTING);  
   
  SetglSprite(true);  
  TextureTGASelectID(0);  
  BillboardBegin(0,0,0);  
  Quad(-0.5,-1,0, 0.5,-1,0, -0.5,1,0, 0.5,1,0, 1,1);
  BillboardEnd;  
  SetglSpriteOFF;  
  
  glEnable(GL_LIGHTING);
end;


procedure OpenGL_CreateList();

procedure OpenGL_Texture();
begin    
  
  TextureLoadTGAID('rain.tga',0);
  TextureLoadID('stoneblocks.bmp',0);
  
end;
begin 

  OpenGL_Texture();
  
  rain.Init(3000, 3, 1-randomf(0.5),1-randomf(0.5),1-randomf(0.5));
  rain.SetRandomSize(-0.25);   
  rain.SetLimitsY(-5,100);	
  
end;


procedure OpenGL_Draw();

procedure OpenGL_Draw2D();
begin
 
  OpenGL_I2D(0,0,0,0);       // inizializza la grafica 2D 
  
  OpenGL_Init(200,0,0,0,0);  // reimposta la grafica 3D
  
end;
procedure OpenGL_Mouse2D();
begin
  
end;
procedure OpenGL_Keyboard();
begin
  
end;
begin

  glClear(GL_COLOR_BUFFER_BIT OR GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();
 
  OpenGL_Draw2D();               // carica gli elementi per la grafica 2d 
  OpenGL_Mouse2D();              // carica i comandi del mause per la grafica 2d
  OpenGL_Keyboard();             // carica i comandi della tastiera
  	
  glTranslatef(0,-5,-40);        // regola l'inquadratura degli elementi nello schermo
  glRotatef(0,1,0,0); 
  
  SetglMouseMove(GL_M0,2);    
  
  PutglPointLight(GL_LIGHT0,0, 0,10,0, 0.1);    

  //if SwitchFog then f:=0.01 else f:=0;
  SetglFog(0,0.5,0.01,0.65,0.65,0.65,GL_EXP);   
  
  // stanza
  TextureSelectID(0);
  TwoSideON;
  glCullFace(GL_FRONT);   
  Cubo(-70,-5,-70, 70,100,70, 70/4);   
  glCullFace(GL_BACK);  
  TwoSideOFF;
  
  Cubo2(-2,0,-30, -2,-5,-2, 2,3,2, 1/4);    
  Cubo2(-10,0,-30, -2,-5,-2, 2,10,2, 1/4); 
  Cubo2(10,0,-15, -2,-5,-2, 2,10,2, 1/4);
  
  SetglFogOFF;  
  rain.AddParticle(RainParticle); 
  SetglFogON;    
  rain.CreateParticle(0,0, 0,0);   
  rain.Switch(true);
  
end;

// inizio del programma
begin

 if MessageBox(0,'Settare lo schermo intero?  ', 'Video!',MB_YESNO OR MB_ICONQUESTION) = IDNO 
  then fullscreen := false else fullscreen := true;
  
 OGLWindowSetting(ARROW,'',GENERIC,'');
 CreateOGLWindow('Pioggia con particelle billboard', 800, 600, 32, fullscreen);// si possono usare anche dei rapporti diversi da 4/3 o 16/9
 OpenGL_Init(200,0,0,0,0);			  // inizializza la grafica OpenGL(consente d'impostare il colore di sfondo e la profondit della visuale) 
 SetglRefractive();                         // imposta la rifrazione ambientale ed elimina le facce interne
 SetglLight(GL_LIGHT0,0.0,0.0,0.0,0.1);     // imposta la luce ambientale
 OpenGL_CreateList();                       // carica le liste degli oggetti (modelli composti)

 // impostare qui i valori delle variabili   

 REPEAT				     // inizio del ciclo principale

 glCLEAR(GL_COLOR_BUFFER_BIT);
 Setglmsg();

 OpenGL_Draw();             // carica gli elementi che devono essere un aggiornati sullo schermo 
 SwapBuffers(dcWindow);	    // abilita la visualizzazione grafica OpenGL

 // inserire qui eventuali dati aggiuntivi

UNTIL active = false;		// fine del ciclo principale (premere ESC per uscire)

 DeleteOGLWindow();		    // chiude la finestra
end.
