
{$APPTYPE GUI}{$MODE DELPHI}

program demo37;

uses
  SysUtils,windows,math,gl,glu,GraphOGL,GOGL_Collision;

//const
 
//type
  
//var 
   
//{$R *.rc}
//{$R *.res}  
 
 
procedure Quad(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4:glFloat);
begin
  TwoSideON;
  glDisable(GL_CULL_FACE);
  glBegin(GL_QUADS);
   FindNormal(x2,y2,z2,x1,y1,z1,x3,y3,z3);
   glNormal3f(FNormal[1], FNormal[2], FNormal[3]);
	LineFree(1,1, 0,1, x2,y2,z2, x1,y1,z1,true);
	LineFree(0,0, 1,0, x3,y3,z3, x4,y4,z4,true);	
  glEnd;
  glEnable(GL_CULL_FACE);
  TwoSideOFF;  
end; 


procedure OpenGL_CreateList();

procedure OpenGL_Texture();
begin    
  
  TextureLoadID('muro01.bmp',0);
  TextureLoadTGAID('Font.tga',0);
  
end;
begin 

  OpenGL_Texture();
  
  glClearStencil(6); // serve per eliminare le tracce residue durante il rendering 
  
end;


procedure OpenGL_Draw();

procedure OpenGL_Draw2D();
begin
 
  OpenGL_I2D(0,0,0,0);       // inizializza la grafica 2D 
  
  OpenGL_Init(100,0,0,0,0);  // reimposta la grafica 3D
  
end;
procedure OpenGL_Mouse2D();
begin
  
end;
procedure OpenGL_Keyboard();
begin
  
end;
begin

  glClear(GL_COLOR_BUFFER_BIT OR GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();
 
  OpenGL_Draw2D();               // carica gli elementi per la grafica 2d 
  OpenGL_Mouse2D();              // carica i comandi del mause per la grafica 2d
  OpenGL_Keyboard();             // carica i comandi della tastiera
  
  glTranslatef(0,-1,-30);        // regola l'inquadratura degli elementi nello schermo
  glRotatef(45,1,0,0); 
  
  SetglMouseMove(GL_M0,2);    
  
  PutglPointLight(GL_LIGHT0,0, 0,10,0, 0.1); 

  glClear(GL_STENCIL_BUFFER_BIT);  
  
  DecalBegin; // inizio decal
  
  // inizio area elementi senza decal
  TextureSelectID(0);  
  glPushMatrix;
  glTranslatef(0,6,0);    
  glRotatef(90,1,0,0); 
  Sfera(0,0,0, 4,20,20, 1/3);
  glPopMatrix;  

  // fine area elementi senza decal  
  DecalSetMax(6); // imposta il massimo numero di elementi con decal
  
  TextureOFF;
  glDisable(GL_LIGHTING);  
  
  glColor3f(1,1,1); 
  Quad(-10,0,-10, 10,0,-10, -10,0,10, 10,0,10); 
  
  DecalSetID(1); // imposta decal all'elemento 1	
  glColor3f(255/256, 218/256, 0); 
  glPushMatrix;
  glRotatef(90,1,0,0); 
  Cono(0,0,0, 32,10, 0);
  glPopMatrix;
  
  DecalSetID(2); // imposta decal all'elemento 2		
  glColor3f(0, 145/256, 255/256); 
  glPushMatrix;
  glRotatef(90,1,0,0); 
  Cono(0,0,0, 32,9.5, 0);
  glPopMatrix;  
  
  DecalSetID(3); // imposta decal all'elemento 3		
  glColor3f(72/256, 0, 255/256); 
  glPushMatrix;
  glRotatef(90,1,0,0); 
  Cono(0,0,0, 32,9, 0);
  glPopMatrix; 

  DecalSetID(4); // imposta decal all'elemento 4		
  glColor3f(72/256, 0, 255/1.2/256); 
  glPushMatrix;
  glRotatef(90,1,0,0); 
  Cono(0,0,0, 32,8.5, 0);
  glPopMatrix;   
  
  DecalSetID(5); // imposta decal all'elemento 5		
  glColor3f(0, 255/256, 145/256);   
  Quad(-7,0,-7, 7,0,-7, -7,0,7, 7,0,7);   

  glEnable(GL_LIGHTING);  
  TextureON;   
 
  DecalSetID(6); // imposta decal all'elemento 6	 
  glColor3f(0.8,0,0);
  SetglSprite;  
  glPushMatrix;   
  glRotatef(90,-1,0,0);   
  TextureTGASelectID(0);
  AddFontString(-16,-2, 0.3, 1,'Decal');
  glPopMatrix;  
  SetglSpriteOFF;
  
  DecalEnd; // fine decal
  
end;

// inizio del programma
begin

 if MessageBox(0,'Settare lo schermo intero?  ', 'Video!',MB_YESNO OR MB_ICONQUESTION) = IDNO 
  then fullscreen := false else fullscreen := true;
  
 OGLWindowSetting(ARROW,'',GENERIC,'');
 CreateOGLWindow('Dimostrazione di decal', 800, 600, 32, fullscreen);// si possono usare anche dei rapporti diversi da 4/3 o 16/9
 OpenGL_Init(100,0,0,0,0);			  // inizializza la grafica OpenGL(consente d'impostare il colore di sfondo e la profondit della visuale) 
 SetglRefractive();                         // imposta la rifrazione ambientale ed elimina le facce interne
 SetglLight(GL_LIGHT0,0.0,0.0,0.0,0.1);     // imposta la luce ambientale
 OpenGL_CreateList();                       // carica le liste degli oggetti (modelli composti)

 // impostare qui i valori delle variabili   

 REPEAT				     // inizio del ciclo principale

 glCLEAR(GL_COLOR_BUFFER_BIT);
 Setglmsg();

 OpenGL_Draw();             // carica gli elementi che devono essere un aggiornati sullo schermo 
 SwapBuffers(dcWindow);	    // abilita la visualizzazione grafica OpenGL

 // inserire qui eventuali dati aggiuntivi

UNTIL active = false;		// fine del ciclo principale (premere ESC per uscire)

 DeleteOGLWindow();		    // chiude la finestra
end.
